# Copyright (C) 2022 Thomas Hoppe (h0bB1T). All rights reserved.
#
# Unauthorized copying of this file via any medium is strictly prohibited.
# Proprietary and confidential.

from bpy.types import UILayout

from ..registries.textures.texture_entry import TextureEntry


def insert_pbr_channels(cm: UILayout, image: TextureEntry, short: bool = False):
    """
    Insert row with available PBR channels as icons into layout.
    """
    if image.info.pbr.alpha: cm.label(text='' if short else 'AL', icon='IMAGE_ALPHA')
    if image.info.pbr.ao: cm.label(text='' if short else 'AO', icon='SNAP_VOLUME')
    if image.info.pbr.specular: cm.label(text='' if short else 'SP', icon='NODE_MATERIAL')
    if image.info.pbr.metal: cm.label(text='' if short else 'ME', icon='SHADING_RENDERED')
    if image.info.pbr.roughness or image.info.pbr.glossiness: cm.label(text='' if short else 'RO', icon='MOD_NOISE')
    if image.info.pbr.normal or image.info.pbr.height: cm.label(text='' if short else 'NO', icon='RNDCURVE')
    if image.info.pbr.displace: cm.label(text='' if short else 'DI', icon='MOD_DISPLACE')
    if image.info.pbr.emission: cm.label(text='' if short else 'EM', icon='LIGHT')   

